﻿''' <summary>
'''Tape 类封装了 VCR 磁带的概念。该类
'''能够记录帧，还能够返回上一批和
'''下一批帧。
''' </summary>
''' <remarks></remarks>
Public Class Tape
    Protected frameArray As New ArrayList()
    Private frames As New System.Collections.Generic.List(Of TapeFrame)
    'tapePosition 保存已获取或添加的上一个帧的值。
    Protected tapePosition As Integer = 0

    Public Sub New()
        '从空白磁带开始。
    End Sub

    Public Sub Clear()
        frames.Clear()
    End Sub

    ''' <summary>
    '''记录时调用此方法来存储帧。
    ''' </summary>
    ''' <param name="channel"></param>
    ''' <param name="frame"></param>
    ''' <remarks></remarks>
    Public Sub SaveFrame(ByVal channel As Integer, ByVal frame As Integer)
        Dim tf As New TapeFrame(channel, frame)
        If tapePosition < frameArray.Count Then
            frames(tapePosition) = tf
            tapePosition += 1
        Else
            frames.Add(tf)
            tapePosition = frames.Count - 1
        End If
    End Sub

    ''' <summary>
    '''播放或快进时调用此方法来
    '''获取下一帧。停留在最后一帧上。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetNextFrame() As TapeFrame
        If tapePosition < frames.Count - 1 Then
            tapePosition += 1
        End If
        Return frames(tapePosition)
    End Function

    ''' <summary>
    '''倒带时调用此方法来获取上一帧。
    '''停留在 0。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetPreviousFrame() As TapeFrame
        If tapePosition > 0 Then
            tapePosition -= 1
        End If
        Return frames(tapePosition)
    End Function

    ''' <summary>
    '''即时倒带方法。
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Rewind()
        tapePosition = 0
    End Sub
End Class